-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
dofile( "scripts/help_style.lua" );



asset1 = "images/machines/trendmill_1/normal";
asset2 = "images/machines/bench_1/normal";
asset3 = "images/machines/rowing_1/normal";
asset4 = "images/machines/bike_1/normal";

Box1Tx = "help_machine_text_1_header";
Box2Tx = "help_machine_text_2_header";
Box3Tx = "help_machine_text_3_header";
Box4Tx = "help_machine_text_4_header";

definition1Tx = "help_machine_text_1";
definition2Tx = "help_machine_text_2";
definition3Tx = "help_machine_text_3";
definition4Tx = "help_machine_text_4";

MakeDialog
{
	-- Name the modal dialog
	name="help3",
	Bitmap
	{
		image="images/backgrounds/bgpopup01",
		x=kCenter,
		y=kCenter,
	
		Bitmap
		{
			image="images/ui/common/popup05",
			x=0,
			y=0,
		};
--Tittle
		Text
		{
			font = BigPopupFont,
			x=kCenter,
			y=kTitleY,
			w=kMax,h=45,
			flags = kHAlignCenter + kVAlignCenter,
			label = "help",
		};
--Header
		Text
		{
			font = PopupFont,
			x=kTextHeaderX,
			y=kTextHeaderY,
			w=kMax,h=45,
			flags = kHAlignLeft + kVAlignCenter,
			label = "help_header_machine",
		};
--Line 1
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine,
			Bitmap
			{
				image=asset1,
				x=20,
				y=5,
				scale = 0.8,
			};
		};
--Machine1 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box1Tx,
			};
		};
		SetStyle(HelpTxDefStyle),
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox,
			label = definition1Tx,
		};
--Line 2
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+kLineSpace,
			Bitmap
			{
				image=asset2,
				x=20,
				y=5,
				scale = 0.8,
			};
		};
--Machine2 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kLineSpace,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box2Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+kLineSpace,
			label = definition2Tx,
		};
--Line 3
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+2*kLineSpace,
			Bitmap
			{
				image=asset3,
				x=10,
				y=15,
				scale = 0.8,
			};
		};
--Machine3 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+2*kLineSpace,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box3Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+2*kLineSpace,
			label = definition3Tx,
		};
--Line 4
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+3*kLineSpace,
			Bitmap
			{
				image=asset4,
				x=25,
				y=5,
				scale = 0.8,
			};
		};
--Machine4 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+3*kLineSpace,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box4Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+3*kLineSpace,
			label = definition4Tx,
		};
		SetStyle(FitnessButtonStyleTittleSmallBlue),
--//Back
		SBButton
		{
			x=kButtonX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconback",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                    SwapToModal("scripts/help2.lua");
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "common.back.label",
		};
--Next
		SBButton
		{
			x=kButtonX+kButtonSpaceX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconplay",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
					SwapToModal("scripts/help4.lua");
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX+kButtonSpaceX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "next",
		};
--Paginate
		Text
		{
			font = SmallFontBlack,
			flags = kHAlignCenter + kVAlignCenter,
			x=kPaginateX,
			y=kPaginateY,
			w=kMax,h=30,
			
			label = "help_paginate_3",
		};
	}
}

